// formverse-block.js
( function( blocks, editor, components, i18n, element ) {
    var el = element.createElement;
    var withSelect = wp.data.withSelect;

    blocks.registerBlockType( 'formverse/connect', {
        title: 'Formverse Form',
        icon: 'feedback',
        category: 'widgets',
        attributes: {
            formId: { type: 'string' },
            formTitle: { type: 'string' }
        },
        edit: function( props ) {
            const { attributes, setAttributes, className } = props;
            const [forms, setForms] = element.useState([]);
            const [loading, setLoading] = element.useState(true);

            element.useEffect(() => {
                // AJAX fetch
                wp.apiRequest({ path: '/formverse/v1/forms' }).then((data) => {
                    setForms(data.forms || []);
                    setLoading(false);
                });
            }, []);

            if (loading) {
                return el('div', { className }, 'Loading forms...');
            }

            if (!forms.length) {
                return el('div', { className }, 'No forms available or API key missing.');
            }

            return el('div', { className },
                el('label', {}, 'Select Form: '),
                el(components.SelectControl, {
                    value: attributes.formId || '',
                    options: [
                        { label: '-- Choose Form --', value: '' },
                        ...forms.map(f => ({
                            label: (f.admin_title || f.name || f.title || 'Untitled') + ' (#' + f.id + ')',
                            value: f.id
                        }))
                    ],
                    onChange: (val) => {
                        const form = forms.find(f => String(f.id) === String(val));
                        setAttributes({ formId: val, formTitle: form ? (form.admin_title || form.name || form.title || '') : '' });
                    }
                }),
                attributes.formId ? el('pre', {}, `[formverse_form id="${attributes.formId}"]`) : null
            );
        },
        save: function( props ) {
            return '[formverse_form id="' + props.attributes.formId + '"]';
        }
    } );
} )(
    window.wp.blocks,
    window.wp.editor,
    window.wp.components,
    window.wp.i18n,
    window.wp.element
);
