(function() {
    tinymce.create('tinymce.plugins.formverse', {
        init : function(ed, url) {
            ed.addButton('formverse', {
                title : 'Insert Formverse Form',
                image: url + '/formverse.svg', // Place this icon in your plugin directory
                onclick : function() {
                    // 1. Show a dialog with loading message (disabled Insert)
                    var dialog;
                    var formOptions = [{text: 'Loading forms...', value: ''}];

                    function openDialog(options, insertEnabled) {
                        ed.windowManager.open({
                            title: 'Insert Formverse Form',
                            width: 400,
                            height: 180,
                            body: [{
                                type: 'listbox',
                                name: 'form_id',
                                label: 'Select Form',
                                values: options
                            }],
                            onsubmit: function(e) {
                                if (e.data.form_id) {
                                    ed.insertContent('[formverse_form id="' + e.data.form_id + '"]');
                                }
                            }
                        });
                    }

                    openDialog(formOptions, false);

                    // 2. When AJAX completes, close and reopen with forms
                    jQuery.get(ajaxurl, { action: 'formverse_get_forms_for_editor' }, function(resp) {
                        var forms = (resp && resp.forms) ? resp.forms : [];
                        var options = [{text:'-- Choose Form --', value:''}];
                        if (forms.length) {
                            for (var i=0; i<forms.length; i++) {
                                var f = forms[i];
                                options.push({
                                    text: (f.admin_title || f.name || f.title || 'Untitled') + ' (#' + f.id + ')',
                                    value: f.id
                                });
                            }
                        } else {
                            options = [{text:'No forms found', value:''}];
                        }
                        // Close previous dialog and open a new one with loaded options
                        ed.windowManager.close();
                        openDialog(options, true);
                    });
                }
            });
        }
    });
    tinymce.PluginManager.add('formverse', tinymce.plugins.formverse);
})();
